unit Satelits;

interface

type
 TptSatelits = ^TSatelits;
 TSatelits   = record
 Name   : string[32];   //  
 Size   : string[64];   //  / 
 Mass   : string[32];   // 
 Orbit  : string[64];   //   
 Period : string[32];   //  
 EDat   : string[16];   //  
end;

type
 TptSatArr = ^TSatArr;
 //   
 TSatArr   = array [0..0] of TSatelits;

//  
const SatEarth : array [0..0] of TSatelits =
(
  (Name   : '';
   Size   : ' 3476 .';
   Mass   : '7,3477E22 .';
   Orbit  : '384400 .';
   Period : '  1,03 /';
   EDat   : '')
);

//  
const SatMars : array [0..1] of TSatelits =
(
  //--------------------
  (Name   : '';
   Size   : ' 23 .';
   Mass   : '1,072E16 .';
   Orbit  : '9400 .';
   Period : '7  29  27 ';
   EDat   : '1877 .'),
   //--------------------
   (Name  : '';
   Size   : ' 16 .';
   Mass   : '1,48E15 .';
   Orbit  : '23460 .';
   Period : '1  6  17 ';
   EDat   : '1877 .')
);

//  
const SatJupiter : array [0..62] of TSatelits = (
( Name : '';	   Size : '60?40?34 .';	   Mass : '~3.6E16 .';	Orbit : '127 690 .';	 Period : '+7 4 29';	 EDat : '1980 .' ),
( Name : '';	 Size : '20?16?14 .';	   Mass : '~2E15 .';	  Orbit : '128 690 .';	 Period : '+7 9 30';	 EDat : '1979 .' ),
( Name : '';	 Size : '250?146?128 .'; Mass : '2.08E18 .';	Orbit : '181 366 .';	 Period : '+11 57 22.67';	  EDat : '1892 .' ),
( Name : '';	     Size : '116?98?84 .';	 Mass : '~4.3EE17 .';	Orbit : '221 889 .';	 Period : '+16 11 17';	      EDat : '1980 .' ),
( Name : '';	       Size : '3660.0?3637.4?3630.6 .';	 Mass : '8.9E22 .';	 Orbit : '421 700 .';	 Period : '+1.769137786 .';	EDat : '1610 .' ),
( Name : '';	   Size : '3121.6 .';	     Mass : '4.8E22 .';	  Orbit : '671 034 .';	 Period : '+3.551181041 .';	        EDat : '1610 .' ),
( Name : '';	   Size : '5262.4 .';	     Mass : '1.5EE23 .';	Orbit : '1 070 412 .';	 Period : '+7.15455296 .';	      EDat : '1610 .' ),
( Name : '';	 Size : '4820.6 .';	     Mass : '1.1E23 .';	  Orbit : '1 882 709 .';	 Period : '+16.6890184 .';	      EDat : '1610 .' ),
( Name : '';	   Size : '8 .';	 Mass : '6.9E14 .';	 Orbit : '7 393 216 .';	  Period : '+129.87 .';	 EDat : '1975 .' ),
( Name : '';	     Size : '10 .';	 Mass : '1.1E16 .';	 Orbit : '11 187 781 .';  Period : '+241.75 .';	 EDat : '1974 .' ),
( Name : '';	   Size : '170 .'; Mass : '6.7E18 .';	 Orbit : '11 451 971 .';  Period : '+250.37 .';	 EDat : '1904 .' ),
( Name : '';	   Size : '36 .';	 Mass : '6.3E16 .';	 Orbit : '11 740 560 .';	Period : '+259.89 .';	 EDat : '1938 .' ),
( Name : '';	     Size : '86 .';	 Mass : '8.7E17 .';	 Orbit : '11 778 034 .';	Period : '+261.14 .';	 EDat : '1905 .' ),
( Name : 'S/2000 J 11'; Size : '4 .';	 Mass : '9.0E13 .';	 Orbit : '12 570 424 .';	Period : '+287.93 .';	 EDat : '2001 .' ),
( Name : '';	     Size : '3 .';	 Mass : '4.5E13 .';	 Orbit : '17 144 873 .';	Period : '+458.62 .';	 EDat : '2003 .' ),
( Name : 'S/2003 J 12'; Size : '1 .';	 Mass : '1.5E12 .';	 Orbit : '17 739 539 .';	Period : '?482.69 .';	 EDat : '2003 .' ),
( Name : '';	   Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '19 088 434 .';	Period : '?538.78 .';	 EDat : '2002 .' ),
( Name : 'S/2003 J 3';  Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '19 621 780 .';	Period : '?561.52 .';	 EDat : '2003 .' ),
( Name : 'S/2003 J 18'; Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '19 812 577 .';	Period : '?569.73 .';	 EDat : '2003 .' ),
( Name : ''; Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '20 453 753 .';	Period : '?597.61 .';	 EDat : '2004 .' ),
( Name : '';	   Size : '3 .';	 Mass : '4.5E13 .';	 Orbit : '20 464 854 .';	Period : '?598.09 .';	 EDat : '2002 .' ),
( Name : '';	   Size : '4 .';	 Mass : '9.0E13 .';	 Orbit : '20 540 266 .';	Period : '?601.40 .';	 EDat : '2003 .' ),
( Name : '';	   Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '20 567 971 .';	Period : '?602.62 .';	 EDat : '2002 .' ),
( Name : '';	   Size : '5 .';	 Mass : '1.9E14 .';	 Orbit : '20 722 566 .';	Period : '?609.43 .';	 EDat : '2001 .' ),
( Name : 'S/2003 J 16'; Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '20 743 779 .';	Period : '?610.36 .';	 EDat : '2003 .' ),
( Name : ''; Size : '7 .';	 Mass : '4.3E14 .';	 Orbit : '20 823 948 .';	Period : '?613.90 .';	 EDat : '2001 .' ),
( Name : '';	 Size : '4 .';	 Mass : '1.2E14 .';	 Orbit : '21 063 814 .';	Period : '?624.54 .';	 EDat : '2001 .' ),
( Name : '';	     Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '21 129 786 .';	Period : '?627.48 .';	 EDat : '2003 .' ),
( Name : '';	 Size : '4 .';	 Mass : '9.0E13 .';	 Orbit : '21 182 086 .';	Period : '?629.81 .';	 EDat : '2002 .' ),
( Name : '';	     Size : '4 .';	 Mass : '9.0E13 .';	 Orbit : '21 405 570 .';	Period : '?639.80 .';	 EDat : '2002 .' ),
( Name : '';	   Size : '28 .';	 Mass : '3.0E16 .';	 Orbit : '21 454 952 .';	Period : '?642.02 .';	 EDat : '1951 .' ),
( Name : 'S/2003 J 17';	Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '22 134 306 .';	Period : '?672.75 .';	 EDat : '2003 .' ),
( Name : '';	     Size : '3 .';	 Mass : '4.5E13 .';	 Orbit : '22 285 161 .';	Period : '?679.64 .';	 EDat : '2002 .' ),
( Name : '';	     Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '22 409 207 .';	Period : '?685.32 .';	 EDat : '2002 .' ),
( Name : '';	   Size : '5 .';	 Mass : '1.6E14 .';	 Orbit : '22 438 648 .';	Period : '?686.67 .';	 EDat : '2001 .' ),
( Name : 'S/2003 J 19'; Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '22 709 061 .';	Period : '?699.12 .';	 EDat : '2003 .' ),
( Name : '';	   Size : '4 .';	 Mass : '7.5E13 .';	 Orbit : '22 713 444 .';	Period : '?699.33 .';	 EDat : '2001 .' ),
( Name : 'S/2003 J 15'; Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '22 720 999 .';	Period : '?699.68 .';	 EDat : '2003 .' ),
( Name : 'S/2003 J 10'; Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '22 730 813 .';	Period : '?700.13 .';	 EDat : '2003 .' ),
( Name : 'S/2003 J 23'; Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '22 739 654 .';	Period : '?700.54 .';	 EDat : '2004 .' ),
( Name : '';	   Size : '3 .';	 Mass : '4.5E13 .';	 Orbit : '22 986 266 .';	Period : '?711.96 .';	 EDat : '2001 .' ),
( Name : '';	     Size : '4 .';	 Mass : '9.0E13 .';	 Orbit : '23 044 175 .';	Period : '?714.66 .';	 EDat : '2003 .' ),
( Name : '';	 Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '23 111 823 .';	Period : '?717.81 .';	 EDat : '2003 .' ),
( Name : '';	   Size : '5 .';	 Mass : '1.9E14 .';	 Orbit : '23 180 773 .';	Period : '?721.02 .';	 EDat : '2001 .' ),
( Name : '';	     Size : '46 .';	 Mass : '1.3E17 .';	 Orbit : '23 197 992 .';	Period : '?721.82 .';	 EDat : '1938 .' ),
( Name : '';	 Size : '9 .';	 Mass : '8.7E14 .';	 Orbit : '23 214 986 .';	Period : '?722.62 .';	 EDat : '2000 .' ),
( Name : '';	 Size : '3 .';	 Mass : '4.5E13 .';	 Orbit : '23 230 858 .';	Period : '?723.36 .';	 EDat : '2002 .' ),
( Name : '';	   Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '23 307 318 .';	Period : '?726.93 .';	 EDat : '2002 .' ),
( Name : '';	   Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '23 396 269 .';	Period : '?731.10 .';	 EDat : '2003 .' ),
( Name : '';	 Size : '4 .';	 Mass : '9.0E13 .';	 Orbit : '23 483 694 .';	Period : '?735.20 .';	 EDat : '2003 .' ),
( Name : 'S/2003 J 4'; Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '23 570 790 .';	Period : '?739.29 .';	 EDat : '2003 .' ),
( Name : '';	   Size : '60 .';	 Mass : '3.0E17 .';	 Orbit : '23 609 042 .';	Period : '?741.09 .';	 EDat : '1908 .' ),
( Name : '';	 Size : '3 .';	 Mass : '4.5E13 .';	 Orbit : '23 702 511 .';	Period : '?745.50 .';	 EDat : '2003 .' ),
( Name : '';	     Size : '3 .';	 Mass : '4.5E13 .';	 Orbit : '23 717 051 .';	Period : '?746.19 .';	 EDat : '2002 .' ),
( Name : '';	   Size : '4 .';	 Mass : '7.5E13 .';	 Orbit : '23 800 647 .';	Period : '?750.13 .';	 EDat : '2001 .' ),
( Name : 'S/2003 J 9'; Size : '1 .';	 Mass : '1.5E12 .';	 Orbit : '23 857 808 .';	Period : '?752.84 .';	 EDat : '2003 .' ),
( Name : 'S/2003 J 5'; Size : '4 .';	 Mass : '9.0E13 .';	 Orbit : '23 973 926 .';	Period : '?758.34 .';	 EDat : '2003 .' ),
( Name : '';	   Size : '38 .';	 Mass : '7.5E16 .';	 Orbit : '24 057 865 .';	Period : '?762.33 .';	 EDat : '1914 .' ),
( Name : '';	   Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '24 252 627 .';	Period : '?771.60 .';	 EDat : '2002 .' ),
( Name : '';	   Size : '4 .';	 Mass : '9.0E13 .';	 Orbit : '24 264 445 .';	Period : '?772.17 .';	 EDat : '2002 .' ),
( Name : '';	     Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '23 345 093 .';	Period : '?776.02 .';	 EDat : '2003 .' ),
( Name : '';	 Size : '5 .';	 Mass : '2.1E14 .';	 Orbit : '24 687 239 .';	Period : '?792.44 .';	 EDat : '2001 .' ),
( Name : 'S/2003 J 2'; Size : '2 .';	 Mass : '1.5E13 .';	 Orbit : '30 290 846 .';	Period : '?1077.02 .';	 EDat : '2003 .' )
);

//  
const SatSaturn : array [0..61] of TSatelits = (
( Name : '';	   Size : '397 .';	  Mass : '3.7E19 .';	Orbit : '185 600 .';	  Period : '0.94 .';	  EDat : '1789 .' ),
( Name : '';	 Size : '499 .';	  Mass : '1.1E20 .';	Orbit : '238 100 .';	  Period : '1.37 .';	  EDat : '1789 .' ),
( Name : '';	   Size : '1060 .';	  Mass : '6.2E20 .';	Orbit : '294 700 .';	  Period : '1.89 .';	  EDat : '1684 .' ),
( Name : '';	   Size : '1118 .';	  Mass : '1.1E21 .';	Orbit : '377 400 .';	  Period : '2.74 .';	  EDat : '1684 .' ),
( Name : '';	     Size : '1528 .';	  Mass : '2.3E21 .';	Orbit : '527 100 .';	  Period : '4.518 .';	  EDat : '1672 .' ),
( Name : '';	   Size : '5150 .';	  Mass : '1.3E23 .';	Orbit : '1 221 900 .';	Period : '15.95 .';	  EDat : '1655 .' ),
( Name : ''; Size : '266 .';	  Mass : '5.7E18 .';	Orbit : '1 464 100 .';	Period : '21.28 .';	  EDat : '1848 .' ),
( Name : '';	   Size : '1436 .';	  Mass : '2.0E21 .';	Orbit : '3 560 800 .';	Period : '79.33 .';	  EDat : '1671 .' ),
( Name : '';	   Size : '240 .';	  Mass : '8.3E18 .';	Orbit : '12 944 000 .';	Period : '548.2 .';	  EDat : '1899 .' ),
( Name : '';	   Size : '178 .';	  Mass : '1.9E18 .';	Orbit : '151 500 .';	  Period : '0.7 .';	    EDat : '1966 .' ),
( Name : ''; Size : '119 .';	  Mass : '5.3E17 .';	Orbit : '151 400 .';	  Period : '0.69 .';	  EDat : '1980 .' ),
( Name : '';	   Size : '32 .';	    Mass : '2.5E15 .';	Orbit : '377 400 .';	  Period : '2.74 .';	  EDat : '1980 .' ),
( Name : '';	 Size : '24 .';	    Mass : '7.2E15 .';	Orbit : '294 700 .';	  Period : '1.89 .';	  EDat : '1980 .' ),
( Name : '';	 Size : '19 .';	    Mass : '3.6E15 .';	Orbit : '294 700 .';	  Period : '1.89 .';	  EDat : '1980 .' ),
( Name : '';	   Size : '32 .';	    Mass : '6.6E15 .';	Orbit : '137 700 .';	  Period : '0.602 .';	  EDat : '1980 .' ),
( Name : ''; Size : '100 .';	  Mass : '1.6E17 .';	Orbit : '139 400 .';	  Period : '0.613 .';	  EDat : '1980 .' ),
( Name : '';	 Size : '84 .';	    Mass : '1.4E17 .';	Orbit : '141 700 .';	  Period : '0.629 .';	  EDat : '1980 .' ),
( Name : '';	     Size : '20 .';	    Mass : '4.9E15 .';	Orbit : '133 600 .';	  Period : '0.575 .';	  EDat : '1990 .' ),
( Name : '';	   Size : '18 .';	    Mass : '4.9E15 .';	Orbit : '23 040 000 .';	Period : '1 315.4 .';	EDat : '2000 .' ),
( Name : '';	 Size : '22 .';	    Mass : '8.2E15 .';	Orbit : '15 200 000 .';	Period : '686.9 .';	  EDat : '2000 .' ),
( Name : '';	 Size : '15 .';	    Mass : '2.7E15 .';	Orbit : '17 983 000 .';	Period : '926.2 .';	  EDat : '2000 .' ),
( Name : '';	 Size : '12 .';	    Mass : '1.2E15 .';	Orbit : '11 124 000 .';	Period : '451.4 .';	  EDat : '2000 .' ),
( Name : '';	 Size : '7 .';	    Mass : '2.1E14 .';	Orbit : '19 459 000 .';	Period : '1 017 .';	  EDat : '2000 .' ),
( Name : '';	 Size : '16 .';	    Mass : '3.3E16 .';	Orbit : '11 111 000 .';	Period : '449.2 .';	  EDat : '2000 .' ),
( Name : ''; Size : '7 .';	  Mass : '2.1E14 .';	Orbit : '18 685 000 .';	Period : '952.6 .';	  EDat : '2000 .' ),
( Name : ''; Size : '32 .';	  Mass : '2.1E16 .';	Orbit : '16 182 000 .';	Period : '783.5 .';	  EDat : '2000 .' ),
( Name : '';	   Size : '8 .';	    Mass : '3.1E14 .';	Orbit : '15 541 000 .';	Period : '728.2 .';	  EDat : '2000 .' ),
( Name : '';	 Size : '10 .';	    Mass : '7.6E14 .';	Orbit : '17 343 000 .';	Period : '871.2 .';	  EDat : '2000 .' ),
( Name : '';	 Size : '40 .';	    Mass : '3.9E16 .';	Orbit : '17 531 000 .';	Period : '895.6 .';	  EDat : '2000 .' ),
( Name : '';	   Size : '7 .';	    Mass : '2.1E14 .';	Orbit : '20 474 000 .';	Period : '1 094 .';	  EDat : '2000 .' ),
( Name : '';	   Size : '7 .';	    Mass : '3.4E14 .';	Orbit : '19 007 000 .';	Period : '1 004 .';	  EDat : '2003 .' ),
( Name : '';	 Size : '3 .';	    Mass : '1.5E13 .';	Orbit : '194 000 .';	  Period : '1.01 .';	  EDat : '2004 .' ),
( Name : '';	 Size : '4 .';	    Mass : '3.5E13 .';	Orbit : '211 000 .';	  Period : '1.14 .';	  EDat : '2004 .' ),
( Name : ''; Size : '4 .';	    Mass : '3.0E13 .';	Orbit : '377 400 .';	  Period : '2.74 .';	  EDat : '2004 .' ),
( Name : '';	 Size : '7 .';	    Mass : '1.5E14 .';	Orbit : '136 500 .';	  Period : '0.594 .';	  EDat : '2005 .' ),
( Name : '';	   Size : '6 .';	    Mass : ' - .';	    Orbit : '20 735 000 .';	Period : '1 116.5 .';	EDat : '2004 .' ),
( Name : '';	 Size : '6 .';	    Mass : ' - .';	    Orbit : '17 119 000 .';	Period : '834.8 .';	  EDat : '2004 .' ),
( Name : '';	 Size : '6 .';	Mass : ' - .';	    Orbit : '19 338 000 .';	Period : '1 006 .';	  EDat : '2004 .' ),
( Name : '';	 Size : '7 .';	    Mass : ' - .';	    Orbit : '20 129 000 .';	Period : '1 084 .';	  EDat : '2004 .' ),
( Name : ''; Size : '5 .';	    Mass : ' - .';	    Orbit : '20 390 000 .';	Period : '1 086 .';	  EDat : '2004 .' ),
( Name : '';	 Size : '4 .';	    Mass : ' - .';	    Orbit : '22 453 000 .';	Period : '1 260 .';	  EDat : '2004 .' ),
( Name : '';	 Size : '6 .';	    Mass : ' - .';	    Orbit : '25 108 000 .';	Period : '1 490.9 .';	EDat : '2004 .' ),
( Name : '';	   Size : '6 .';	    Mass : ' - .';	    Orbit : '19 856 000 .';	Period : '1 039 .';	  EDat : '2004 .' ),
( Name : '';	 Size : '8 .';	  Mass : ' - .';	    Orbit : '18 437 000 .';	Period : '932 .';	    EDat : '2006 .' ),
( Name : '';	   Size : '7 .';	    Mass : ' - .';	    Orbit : '22 118 000 .';	Period : '1 233.6 .';	EDat : '2006 .' ),
( Name : '';	   Size : '6 .';	    Mass : ' - .';	    Orbit : '23 065 000 .';	Period : '1 312.0 .';	EDat : '2006 .' ),
( Name : '';	   Size : '6 .';	    Mass : ' - .';	    Orbit : '17 665 000 .';	Period : '878.3 .';	  EDat : '2006 .' ),
( Name : '';	   Size : '6 .';	    Mass : ' - .';	    Orbit : '22 707 000 .';	Period : '1 297.7 .';	EDat : '2006 .' ),
( Name : '';	   Size : '2 .';	    Mass : ' - .';	    Orbit : '197 700 .';	  Period : '1.037 .';	  EDat : '2007 .' ),
( Name : ''; Size : '6 .';	    Mass : ' - .';	    Orbit : '18 600 000 .';	Period : '942 .';	    EDat : '2006 .' ),
( Name : '';	   Size : '6 .';	    Mass : ' - .';	    Orbit : '18 105 000 .';	Period : '905 .';	    EDat : '2006 .' ),
( Name : '';	 Size : '7 .';	    Mass : ' - .';	    Orbit : '17 920 000 .';	Period : '895 .';	    EDat : '2007 .' ),
( Name : '';	   Size : '0.5 .';	  Mass : ' - .';	    Orbit : '167 500 .';	  Period : '0.80812 .';	EDat : '2008 .' ),
( Name : 'S/2004 S 7';	 Size : '6 .';	Mass : ' - .';	    Orbit : '19 800 000 .';	Period : '1 103 .';	  EDat : '2005 .' ),
( Name : 'S/2004 S 12';	 Size : '5 .';	Mass : ' - .';	    Orbit : '19 650 000 .';	Period : '1 048 .';	  EDat : '2005 .' ),
( Name : 'S/2004 S 13';	 Size : '6 .';	Mass : ' - .';	    Orbit : '18 450 000 .';	Period : '906 .';	    EDat : '2005 .' ),
( Name : 'S/2004 S 17';	 Size : '4 .';	Mass : ' - .';	    Orbit : '18 600 000 .';	Period : '986 .';	    EDat : '2005 .' ),
( Name : 'S/2006 S 1';	 Size : '6 .';	Mass : ' - .';	    Orbit : '18 981 000 .';	Period : '970 .';	    EDat : '2006 .' ),
( Name : 'S/2006 S 3';	 Size : '6 .';	Mass : ' - .';	    Orbit : '21 132 000 .';	Period : '1 142 .';	  EDat : '2006 .' ),
( Name : 'S/2007 S 2';	 Size : '6 .';	Mass : ' - .';	    Orbit : '16 560 000 .';	Period : '800 .';	    EDat : '2007 .' ),
( Name : 'S/2007 S 3';	 Size : '5 .';	Mass : ' - .';	    Orbit : '20 518 500 .';	Period : '1 100 .';	  EDat : '2007 .' ),
( Name : 'S/2009 S 1';	 Size : '0.3 .'; Mass : ' - .';	    Orbit : '117 000 .';	  Period : ' - .';	    EDat : '2009 .' )
);

//  
const SatUranus : array [0..26] of TSatelits = (
( Name : '';	Size : '42  6 .';	     Mass : '5.0E16 ? .';	 Orbit : '49 751 .';	 Period : '0.335034 .';	 EDat : '1986 .' ),
( Name : '';	  Size : '46  8 .';	     Mass : '5.1E16 ? .';	 Orbit : '53 764 .';	 Period : '0.376400 .';	 EDat : '1986 .' ),
( Name : '';	  Size : '54  4 .';	     Mass : '9.2E16 ? .';	 Orbit : '59 165 .';	 Period : '0.434579 .';	 EDat : '1986 .' ),
( Name : '';	Size : '82  4 .';	     Mass : '3.4E17 ? .';	 Orbit : '61 766 .';	 Period : '0.463570 .';	 EDat : '1986 .' ),
( Name : ''; Size : '68  8 .';	     Mass : '2.3E17 ? .';	 Orbit : '62 658 .';	 Period : '0.473650 .';	 EDat : '1986 .' ),
( Name : ''; Size : '106  8 .';      Mass : '8.2E17 ? .';	 Orbit : '64 360 .';	 Period : '0.493065 .';	 EDat : '1986 .' ),
( Name : '';	  Size : '140  8 .';      Mass : '1.7E18 ? .';	 Orbit : '66 097 .';	 Period : '0.513196 .';	 EDat : '1986 .' ),
( Name : ''; Size : '72  12 .';      Mass : '2.5E17 ? .';	 Orbit : '69 927 .';	 Period : '0.558460 .';	 EDat : '1986 .' ),
( Name : '';	  Size : '~ 18 .';	       Mass : '3.8E15 ? .';	 Orbit : '74 800 .';	 Period : '0.618 .';	   EDat : '2003 .' ),
( Name : '';	  Size : '90  16 .';      Mass : '4.9E17 ? .';	 Orbit : '75 255 .';	 Period : '0.623527 .';	 EDat : '1986 .' ),
( Name : '';	  Size : '30  6 .';	     Mass : '1.8E16 ? .';	 Orbit : '76 420 .';	 Period : '0.638 .';	   EDat : '1986 .' ),
( Name : '';	      Size : '162  4 .';      Mass : '2.9E18 ? .';	 Orbit : '86 004 .';	 Period : '0.761833 .';	 EDat : '1985 .' ),
( Name : '';	      Size : '~ 25 .';	       Mass : '1.0E16 ? .';	 Orbit : '97 734 .';	 Period : '0.923 .';	   EDat : '2003 .' ),
( Name : '';	  Size : '471.6  1.4 .';	 Mass : '(6.6  0.7)E19 .';	   Orbit : '129 390 .';	 Period : '1.413479 .';	 EDat : '1948 .' ),
( Name : '';	  Size : '1157.8  1.2 .'; Mass : '(1.35  0.12)E21 .';	 Orbit : '191 020 .';	 Period : '2.520379 .';	 EDat : '1851 .' ),
( Name : '';	Size : '1169.4  5.6 .'; Mass : '(1.17  0.13)E21 .';	 Orbit : '266 300 .';	 Period : '4.144177 .';	 EDat : '1851 .' ),
( Name : '';	  Size : '1577.8  3.6 .'; Mass : '(3.53  0.09)E21 .';	 Orbit : '435 910 .';	 Period : '8.705872 .';	 EDat : '1787 .' ),
( Name : '';	  Size : '1522.8  5.2 .'; Mass : '(3.01  0.07)E21 .';	 Orbit : '583 520 .';	 Period : '13.463239 .';	 EDat : '1787 .' ),
( Name : ''; Size : '~ 12 .';	       Mass : '1.3E15 ? .';	 Orbit : '4 276 000 .';	 Period : '? 267.12 .';	 EDat : '2001 .' ),
( Name : '';	  Size : '~ 98 .';	       Mass : '7.3E17 ? .';	 Orbit : '7 231 000 .';	 Period : '? 579.39 .';	 EDat : '1997 .' ),
( Name : '';	  Size : '~ 20 .';	       Mass : '6E15 ? .';	   Orbit : '8 004 000 .';	 Period : '? 677.48 .';	 EDat : '1999 .' ),
( Name : '';	Size : '~ 10 .';	       Mass : '7.5E14 ? .';	 Orbit : '8 504 000 .';	 Period : '? 748.83 .';  EDat : '2001 .' ),
( Name : ''; Size : '~ 190 .';	       Mass : '5.4E18 ? .';	 Orbit : '12 179 000 .'; Period : '? 1285.62 .'; EDat : '1997 .' ),
( Name : ''; Size : '~ 11 .';	       Mass : '1.3E15 ? .';	 Orbit : '14 345 000 .'; Period : '+1654.32 .';	 EDat : '2003 .' ),
( Name : '';	Size : '~ 30 .';	       Mass : '2.1E16 ? .';	 Orbit : '16 256 000 .'; Period : '? 1962.95 .'; EDat : '1999 .' ),
( Name : '';	  Size : '~ 30 .';	       Mass : '2.1E16 ? .';	 Orbit : '17 418 000 .'; Period : '? 2196.35 .'; EDat : '1999 .' ),
( Name : ''; Size : '~ 12 .';	       Mass : '1.3E15 ? .';	 Orbit : '20 901 000 .'; Period : '? 2805.51 .'; EDat : '2001 .' )
);

//  
const SatNeptun : array [0..12] of TSatelits = (
( Name : '';	 Size : '2707 .';	Mass : '2.1E22 .'; Orbit : '354 800 .';	   Period : '5.877 .';	 EDat : '1846 .' ),
( Name : '';	 Size : '340 .';	Mass : '3.1E19 .'; Orbit : '5 513 400 .';	 Period : '360.14 .';	 EDat : '1949 .' ),
( Name : '';	   Size : '67 .';	  Mass : '1.9E17 .'; Orbit : '48 227 .';	   Period : '0.294 .';	 EDat : '1989 .' ),
( Name : '';	 Size : '81 .';	  Mass : '3.5E17 .'; Orbit : '50 075 .';	   Period : '0.311 .';	 EDat : '1989 .' ),
( Name : '';	 Size : '150 .';	Mass : '2.1E18 .'; Orbit : '52 526 .';	   Period : '0.335 .';	 EDat : '1989 .' ),
( Name : '';	 Size : '175 .';	Mass : '2.1E18 .'; Orbit : '61 953 .';	   Period : '0.429 .';	 EDat : '1989 .' ),
( Name : '';	 Size : '195 .';	Mass : '4.9E18 .'; Orbit : '73 548 .';	   Period : '0.555 .';	 EDat : '1981 .' ),
( Name : '';	 Size : '420 .';	Mass : '5.0E19 .'; Orbit : '117 647 .';	   Period : '1.122 .';	 EDat : '1989 .' ),
( Name : ''; Size : '48 .';	  Mass : '9.0E16 .'; Orbit : '15 728 000 .'; Period : '1879.71 .'; EDat : '2002 .' ),
( Name : '';	 Size : '28 .';	  Mass : '1.5E16 .'; Orbit : '46 695 000 .'; Period : '9115.9 .';	 EDat : '2003 .' ),
( Name : '';	     Size : '44 .';	  Mass : '6.7E16 .'; Orbit : '22 422 000 .'; Period : '2914.0 .';	 EDat : '2002 .' ),
( Name : ''; Size : '42 .';	  Mass : '5.8E16 .'; Orbit : '23 571 000 .'; Period : '3167.85 .'; EDat : '2002 .' ),
( Name : '';	   Size : '60 .';	  Mass : '1.7E17 .'; Orbit : '48 387 000 .'; Period : '9374 .';	   EDat : '2002 .' )
);

//  
const SatPluton : array [0..2] of TSatelits = (
( Name : '';	Size : '1212 .'; Mass : '1.52E21 .'; Orbit : '19 640 .';  Period : '6.387230 .'; EDat : '1978 .' ),
( Name : ''; Size : '88 .';	 Mass : '? E ? .';   Orbit : '48 708 .';  Period : '24.86 .';    EDat : '2005 .' ),
( Name : '';	Size : '~80 .';	 Mass : '~1E17 .';   Orbit : '~65 000 .'; Period : '38.206 .';   EDat : '2005 .' )
);

//  
const SatHaumea : array [0..1] of TSatelits = (
( Name : '';  Size : '310 .';	Mass : '1.79E19 .'; Orbit : '49 880 .';  Period : '49 .';  EDat : '2005 .' ),
( Name : ''; Size : '170 .';	Mass : '1.79E18 .'; Orbit : '25 657 .';  Period : '18 .';  EDat : '2005 .' )
);

//  
const SatEris : array [0..0] of TSatelits = (
( Name : 'c';	Size : '75 .'; Mass : '? E ? .'; Orbit : '37 430  .'; Period : '15.772 .'; EDat : '2005 .' )
);

implementation
end.
